%     NITOOL     NATURE INSPIRED TOOLBOX

% ==============================================
%   PROGRAM AIM : Griewank Function
%     OUT = 0.5+ (sin^2(sqrt(x^2+y^2))-0.5)/((1+0.01*(x^2+y^2))^2)
% ==============================================
%   USAGE :
%         1. OUT = Schaffer([1,2,5;6,0,-50])
%       Minima 0 at all x = 100
% ==============================================
%   SATVIR SINGH SIDHU, ARUN KHOSLA, JASBIR SINGH SAINI
%   JULY 2009
%   COPYRIGHT RESERVED
% ==============================================

function [OUT]= Schaffer(in)
 x=in(:,1);
 y=in(:,2);
 num=sin(sqrt(x.^2+y.^2)).^2 - 0.5;
 den=(1.0+0.01*(x.^2+y.^2)).^2;

 OUT = 0.5+num./den;


